require 'rails_helper'

describe V1::GamePresenter do
  before :all do
    @game = FactoryGirl.create(:game)
    @presenter = V1::GamePresenter.new(@game)
  end

  [:name,
   :cover
  ].each do |attr|
    it "should include #{attr}" do
      allow(@presenter).to receive(:request) { Hashie::Mash.new(url: 'http://www.example.com') }
      expect(@presenter.as_json).to include(attr)
    end
  end
end
