require 'rails_helper'

describe V1::ImagePresenter do
  before :all do
    @image = FactoryGirl.create(:image)
    @presenter = V1::ImagePresenter.new(@image)
  end

  describe 'attributes' do
    it 'should include all specified attributes' do
      attrs = [:id, :url, :tags, :metadata, :created_at, :updated_at]
      expect((@presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
    end
  end

  it 'should have a "url" field that provides the URL for the original image' do
    expect(@presenter.as_json[:url]).to eq(@image.url)
  end
end
