require 'rails_helper'

describe V1::MatchPresenter do
  before :all do
    @match = FactoryGirl.create(:match)
    @presenter = V1::MatchPresenter.new(@match)
  end

  describe 'attributes' do
    it 'should include all specified attributes' do
      attrs = [:id, :game_id, :game, :series_id, :scheduled_at,
               :opponents, :winner_id, :state]
      expect((@presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
    end

    it 'should always order opponents by their IDs' do
      def sorted_by_id?(objects)
        objects.each_cons(2).all? {|a,b| a.id < b.id}
      end
      # Make sure opponents are unsorted in input match.
      while sorted_by_id?(@match.opponents)
        FactoryGirl.create(:opponent, contest: @match)
      end

      json = Hashie::Mash.new(V1::MatchPresenter.new(@match).as_json)
      expect(sorted_by_id?(json.opponents)).to eq(true)
      expect(json.opponents.map(&:id)).to eq(@match.opponents.map(&:id).sort)
    end
  end
end
