require 'rails_helper'

describe V1::OpponentPresenter do
  before :all do
    @series = FactoryGirl.create(:series)
    @opponent = @series.opponents.first
    @presenter = V1::OpponentPresenter.new(@opponent)
  end

  describe 'attributes' do
    it 'should include all specified attributes' do
      attrs = [:contest_id, :contender_id, :contender_type, :score, :winner_id, :disqualified]
      expect((@presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
    end
  end
end
