require 'rails_helper'

describe V1::SeasonPresenter do
  before :all do
    @season = FactoryGirl.create(:season, :with_tournaments)
    @presenter = V1::SeasonPresenter.new(@season)
  end

  [:name, :tournament_ids].each do |attr|
    it "should include #{attr}" do
      expect(@presenter.as_json).to include(attr)
    end
  end
end
