require 'rails_helper'

describe V1::TeamInvitationPresenter do
  before :all do
    @team_invitation = FactoryGirl.create(:team_invitation)
    @presenter = V1::TeamInvitationPresenter.new(@team_invitation)
  end

  it 'should include token outside of production' do
    expect(Rails.env.production?).to eq(false)
    expect(@presenter.as_json).to include(:token)
  end

  it 'should not include token in production' do
    Rails.env = 'production'
    expect(Rails.env.production?).to eq(true)
    expect(@presenter.as_json).to_not include(:token)
    Rails.env = 'test'
  end

  describe 'associations' do
    it 'should use the appropriate presenters for all associations' do
      @association_presenters = Hash[*@presenter.associations.collect{|a| [a.name, a.options[:serializer].class]}.flatten]
      expect(@association_presenters).to eq({team: V1::TeamPresenter})
    end
  end
end
