require 'rails_helper'

describe V1::TeamMemberPresenter do
  before :all do
    @team = FactoryGirl.create(:team_with_people)
    @presenter = V1::TeamMemberPresenter.new(@team.members.first)
    @hash = @presenter.to_hash
  end

  [:id, :team_id, :user_id, :roles, :verified].each do |incl|
    it "includes #{incl}" do
      expect(@hash.keys).to include(incl)
    end
  end
end
