require 'rails_helper'

describe V1::TeamPresenter do
  before :all do
    @team = FactoryGirl.create(:team)
    @presenter = V1::TeamPresenter.new(@team)
  end

  [ # Basic info
    {name: :name,                 type: String, can_be_nil: false},
    {name: :slug,                 type: String, can_be_nil: false},
    {name: :description,          type: Hash,   can_be_nil: false},
    {name: :social,               type: Hash,   can_be_nil: false},
    {name: :website,              type: String, can_be_nil: true},
    {name: :join_token,           type: String, can_be_nil: false},
    {name: :country,              type: String, can_be_nil: true},
    {name: :settings,             type: Hash,   can_be_nil: false},

    # Associations
    {name: :organization_id,      type: String, can_be_nil: true},
    {name: :game_id,              type: String, can_be_nil: true},
    {name: :user_ids,             type: Array,  can_be_nil: false},
    {name: :team_invitation_ids,  type: Array,  can_be_nil: false},
    {name: :tournament_entry_ids, type: Array,  can_be_nil: false},
    {name: :team_members,         type: Array,  can_be_nil: false},
    {name: :users,                type: Array,  can_be_nil: false},
    {name: :team_invitations,     type: Array,  can_be_nil: false},
    {name: :tournament_entries,   type: Array,  can_be_nil: false},

    # Special handling / virtual
    {name: :memberships,          type: Hash,   can_be_nil: false},
    {name: :region,               type: String, can_be_nil: true},
    {name: :logo,                 type: Hash, can_be_nil: true},
    {name: :cover,                type: Hash, can_be_nil: true},
  ].each do |attr|
    it "should include #{attr[:name]}" do
      allow(@presenter).to receive(:request) { Hashie::Mash.new(url: 'http://www.example.com') }
      json = @presenter.as_json
      expect(json).to include(attr[:name])
      attr_value = json[attr[:name]]
      expect(attr_value).to_not be_nil unless attr[:can_be_nil]
      expect(attr_value).to be_a(attr[:type]) unless attr_value.nil?
    end
  end
end
