require 'rails_helper'

describe V1::TournamentEntryPresenter do
  before :all do
    @entry = FactoryGirl.create(:tournament_entry)
    @presenter = V1::TournamentEntryPresenter.new(@entry)
  end

  [:tournament_id,
   :entrant_type,
   :entrant_id,
   :flags].each do |attr|
    it "should include #{attr}" do
      expect(@presenter.as_json).to include(attr)
    end
  end
end
