require 'rails_helper'

describe V1::TournamentPresenter do
  describe 'attributes' do
    before :all do
      @tournament = FactoryGirl.create(:tournament)
      FactoryGirl.create(:tournament_entry, tournament: @tournament)
      @presenter = V1::TournamentPresenter.new(@tournament)
    end

    it 'should include all specified attributes' do
      attrs = [:name, :slug, :description, :tournament_entry_ids, :entrants_type,
               :teams, :team_ids, :stages, :starts_at, :ends_at,
               :cover, :logo, :game, :game_id, :season_id]
      expect((@presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
    end

    [:game, :team, :tournament_stage, :tournament_entry].each do |assoc|
      it 'uses presenters for associations' do
        klass = "V1::#{assoc.to_s.classify}Presenter".constantize
        allow(klass).to receive(:new).and_call_original
        expect(klass).to receive(:new)
        @presenter.as_json
      end
    end
  end

  describe 'teams' do
    it 'should not embed hidden teams' do
      tournament = FactoryGirl.create(:tournament)
      tournament.teams += FactoryGirl.create_list(:team, 5)
      [1,3].each {|i| tournament.teams[i].hidden = true; tournament.teams[i].save!}
      tournament.reload
      visible_ids = tournament.teams.reject(&:hidden).map(&:id).sort

      json = JSON.parse(V1::TournamentPresenter.new(tournament).to_json)
      expect(json['teams'].length).to eq(3)
      expect(json['team_ids'].sort).to eq(visible_ids)
      expect(json['teams'].map{|o|o['id']}.sort).to eq(visible_ids)
      expect(json['teams'].all?{|team| !team['hidden']})
    end
  end
end
