require 'rails_helper'

describe V1::TournamentStagePresenter do
  describe 'methods' do
    before :each do
      @stage = FactoryGirl.create(:tournament_stage)
      @presenter = V1::TournamentStagePresenter.new(@stage)
    end

    it 'includes rounded progress' do
      json = @presenter.as_json
      expect(json[:progress]).to eq(@stage.progress.round(3))
    end
  end

  describe 'attributes' do
    before :all do
      @stage = FactoryGirl.create(:tournament_stage)
      @presenter = V1::TournamentStagePresenter.new(@stage)
    end

    it 'should include all specified attributes' do
      attrs = [:name, :slug, :type, :tournament_id, :starts_at, :ends_at, :progress, :color]
      expect((@presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
    end
  end

  describe 'RoundRobin' do
    describe 'attributes' do
      it 'should include all TournamentStage attributes, plus standings' do
        stage = FactoryGirl.create(:round_robin_stage)
        presenter = V1::TournamentStagePresenter.new(stage)
        attrs = [:name, :type, :tournament_id, :starts_at, :ends_at, :progress, :color, :standings]
        expect((presenter.as_json.keys & attrs).sort).to eq(attrs.sort)
      end
    end
  end
end
