require 'rails_helper'

describe V1::EventsController do
  it_behaves_like 'a CRUD API', {
    for: :event,
  }, ->{{
    create: {title: 'an event title'},
    update: {slug: 'an-event-slug'},
  }}

  it_behaves_like 'an image uploader for', :event, :logo, headers: admin_headers

  describe '#index' do
    before :all do
      times = (-3..3).map(&:day).map(&:from_now)
      @events = times.map {|time| FactoryGirl.create(:event, starts_at: time)}
      @event_ids = @events.map(&:id)
      @today = Time.now.to_s  # intentionally not at start of day
    end

    it 'orders events chronologically' do
      get '/v1/events', params: {ids: @event_ids}
      expect(response.status).to eq(200)
      expect(json_ids.sort).to eq(@event_ids.sort)
      reply_times = json.map {|event| event['starts_at']}
      expect(reply_times).to eq(reply_times.sort)
    end

    it 'filters based on "on"' do
      event_id = @event_ids[3]
      get '/v1/events', params: {ids: @event_ids, on: @today}
      expect(response.status).to eq(200)
      expect(json_ids).to eq([event_id])
    end

    it 'filters based on "from"' do
      get '/v1/events', params: {ids: @event_ids, from: @today}
      expect(response.status).to eq(200)
      expect(json_ids).to eq(@event_ids[3..6])
    end

    it 'filters based on "to"' do
      get '/v1/events', params: {ids: @event_ids, to: @today}
      expect(response.status).to eq(200)
      expect(json_ids).to eq(@event_ids[0..3])
    end

    it 'filters based on both "from" and "to"' do
      get '/v1/events', params: {ids: @event_ids, from: 1.day.ago.to_s, to: 1.day.from_now.to_s}
      expect(response.status).to eq(200)
      expect(json_ids).to eq(@event_ids[2..4])
    end
  end
end
