require 'rails_helper'

describe V1::GamesController do
  it_behaves_like 'a CRUD API', { for: :game }, -> {{
    create: FactoryGirl.build(:game).attributes.compact,
    update: {abbr: 'sc2000'}
  }}

  describe 'GET /games/:id' do
    before :each do
      @game = FactoryGirl.create(:game)
    end

    it 'should return empty cover urls if a team has no cover set' do
      expect(@game.cover.url).to be_nil
      get "/v1/games/#{@game.id}"
      expect(response).to be_ok
      [:original, :preview, :thumb].each do |type|
        expect(json['cover'][type.to_s]).to be_empty
      end
    end

    it 'should prefix cover urls w/ request.base_url when carrierwave returns a relative URI' do
      @game.update_attribute(:cover, File.open('spec/support/files/glitch.png'))
      expect(@game.cover.url).to_not match(/^http/)
      get "/v1/games/#{@game.id}"
      expect(response).to be_ok
      [:original, :preview, :thumb].each do |type|
        expect(json['cover'][type.to_s]).to match(/^http:\/\/www\.example\.com/)
      end
    end
  end

  describe 'PATCH /games/:id' do
    it_behaves_like 'an image uploader for', :game, :cover, {
      headers: {
        'User-ID' => '00000000-0000-0000-0000-000000000000',
        'X-Roles' => 'admin'
      }
    }
  end
end
