require 'rails_helper'

describe V1::TournamentStagesController do
  it_behaves_like 'a CRUD API', {
    for: :tournament_stage,
  }, ->{
    tournament = FactoryGirl.create(:tournament)
    {
      factory_options: {tournament: tournament},
      create: FactoryGirl.build(:tournament_stage, tournament_id: tournament.id) \
                .attributes.symbolize_keys.slice(:tournament_id, :name, :color, :starts_at, :ends_at),
      update: {color: '#000000'},
  }}

  describe 'tournament association' do
    before :all do
      # First two Tournaments are in the same Season, the rest have no Season in common.
      @season = FactoryGirl.create(:season)
      @tournaments = FactoryGirl.create_list(:tournament, 2, season: @season) \
                   + FactoryGirl.create_list(:tournament, 3)
    end

    it 'can filter by tournament_id' do
      tournament = @tournaments[2]
      expect(tournament.stages).to_not be_empty
      get '/v1/tournament_stages', params: {tournament_id: tournament.id}
      expect(response.status).to eq(200), ->{pp json}
      expect(json_ids.sort).to eq(tournament.stage_ids.sort)
    end

    it 'can filter by tournament_ids' do
      tournaments = @tournaments.values_at(0,2,4)
      tournament_ids = tournaments.map(&:id)
      stage_ids = tournaments.map(&:stage_ids).flatten.sort

      get '/v1/tournament_stages', params: {tournament_ids: tournament_ids}
      expect(response.status).to eq(200), ->{pp json}
      expect(json_ids.sort).to eq(stage_ids)
    end

    it 'can filter by season_id' do
      tournaments = @season.tournaments
      tournament_ids = tournaments.map(&:id)
      stage_ids = tournaments.map(&:stage_ids).flatten.sort

      get '/v1/tournament_stages', params: {season_id: @season.id}
      expect(response.status).to eq(200), ->{pp json}
      expect(json_ids.sort).to eq(stage_ids)
    end
  end
end
