require 'rails_helper'

describe V1::UserEventsController do
  describe 'POST /user_events' do
    describe 'USER_CHANGE' do
      before :each do
        @person = FactoryGirl.create(:person, user_id: SecureRandom.uuid)
      end

      it 'should call Person.handle_user_change' do
        expect(Person).to receive(:handle_user_change)
        post '/v1/user_events',
          params: {
            type: 'USER_CHANGE',
            data: {}
          }
        expect(response).to be_ok
      end

      it 'assigns the user to an organization' do
        expect(@person.organizations).to be_empty
        post '/v1/user_events',
          params: {
            type: 'USER_CHANGE',
            data: {
              id: @person.user_id,
              email: 'test@example.com',
              diff: {
                email: [nil, 'test@example.com']
              }
            }
          }
        @person.reload
        expect(@person.organizations).to_not be_empty
      end
    end
  end
end
