require 'rails_helper'

describe Curse do
  before :each do
    @server_id = SecureRandom.uuid
    @auth_token = Base64.strict_encode64(Random.new.bytes(128))
    @curse = Curse.new(@server_id, @auth_token)

    @server_info = {
      'Channels' => FactoryGirl.build_list(:curse_channel, 5, root_group_id: @server_id)
    }
    stub_request(:get, "https://groups-v1.curseapp.net/groups/#{@server_id}").
      to_return(body: @server_info.to_json)
  end

  it 'can build instances of Curse::Channel from JSON replies' do
    chans = @curse.channels
    expect(chans.length).to eq(5)
    expect(chans.map(&:id).sort).to eq(@server_info['Channels'].map{|c|c['GroupID']}.sort)
  end

  it 'caches fetches of server metadata' do
    expect(@curse).to receive(:request).once.and_call_original
    10.times {@curse.channels; @curse.folders}
  end

  it 'should generate invite links' do
    invite = Faker::Internet.url('example.com')
    stub_request(:post, "https://groups-v1.curseapp.net/servers/#{@server_id}/invites").
      to_return(body: {'InviteUrl': invite}.to_json)
    expect(@curse.channels[0].invite).to eq(invite)
  end
end
