shared_context 'common API context' do |options, block|
  before :all do
    @params = block&.call
    @factory = @params&.dig(:factory) || options[:for]
    @factory_options = @params&.dig(:factory_options) || options[:factory_options] || {}
    @model = @params&.dig(:model) || @factory.to_s.classify.constantize
    @route = @params&.dig(:route) || "/v1/#{@factory.to_s.pluralize}"

    @admin_headers = {
      'User-ID' => '00000000-0000-0000-0000-000000000000',
      'X-Roles' => 'admin'
    }
  end

  before :each do
    @object = FactoryGirl.create(@factory, @factory_options)
    @serializer = ActiveModel::Serializer.serializer_for(@object)
    expect(@serializer).to receive(:new).at_least(:once).and_call_original
  end
end
