shared_examples 'a #index API' do |options, block|
  include_context 'common API context', options, block

  describe '#index' do
    it 'returns an array of objects' do
      get @route
      expect(response).to be_ok, "response not ok: #{response.body}"
      expect(json).to be_a(Array)
      json_ids.each do |object_id|
        expect(@model.exists?(object_id)).to eq(true)
      end
    end

    it 'respects limit and offset params' do
      FactoryGirl.create_list(@factory, 5, @factory_options)

      get @route, params: {limit: 5}
      expect(response).to be_ok, "response not ok: #{response.body}"
      expect(json.length).to eq(5)
      full_ids = json_ids

      get @route, params: {limit: 3, offset: 2}
      expect(response).to be_ok, "response not ok: #{response.body}"
      expect(json.length).to eq(3)
      partial_ids = json_ids

      expect(partial_ids).to eq(full_ids[2...5])
    end

    it 'can filter by ids' do
      objects = FactoryGirl.create_list(@factory, 5, @factory_options)
      ids = 0.step(5,2).map {|i| objects[i].id}

      get @route, params: {ids: ids}
      expect(response).to be_ok, "response not ok: #{response.body}"
      expect(json_ids.sort).to eq(ids.sort)

      get @route, params: {ids: ids.join(',')}
      expect(response).to be_ok, "response not ok: #{response.body}"
      expect(json_ids.sort).to eq(ids.sort)
    end
  end
end
