shared_examples 'a #update API' do |options, block|
  include_context 'common API context', options, block

  describe '#update' do
    it 'updates and returns a matching object' do
      patch [@route, @object.id].join('/'),
        params: @params[:update], headers: @admin_headers
      expect(response).to be_ok, "response not ok: #{response.body}"
      expect(json['id']).to eq(@object.id)
      @object.reload
      comparams = @params[:update].stringify_keys.to_a
      expect((@object.attributes.to_a & comparams).sort).to eq(comparams.sort)
      expect((json.to_a & comparams).sort).to eq(comparams.sort)
    end
  end
end
