module ImageHelpers
  def self.gen_image_data(size: '100x100', color: 'white', type: 'png', random: false, path: '-')
    MiniMagick::Tool::Convert.new do |builder|
      builder.size size
      builder.xc color
      if random
        builder << '+noise'
        builder << 'Random'
      end
      builder << "#{type}:#{path}"
    end
  end

  def self.gen_image_file(**options)
    path = options[:path] || begin
      f = Tempfile.new
      path = f.path + '.' + options.fetch(:type, 'png')
      f.unlink
      path
    end
    gen_image_data(**options.merge(path: path))
    path
  end
end
