shared_context 'an image uploader for' do |klass_name, attr, options|
  before :all do
    @extra_params = options&.dig(:params) || {}
    @extra_headers = options&.dig(:headers) || {}
  end

  before :each do
    @object = FactoryGirl.create(klass_name)
    @route = "/v1/#{klass_name.to_s.pluralize}"
    @id_attr = options.to_h.fetch(:id_attr, :id)
  end

  it "#{attr}, allowing updates to via remote_#{attr}_url" do
    image_url = 'http://b.bildgur.de/glitch.png'
    stub_request(:get, image_url).
      to_return(body: File.read('spec/support/files/glitch.png'))
    patch [@route, @object.send(@id_attr)].join('/'),
      params: @extra_params.merge({ "remote_#{attr}_url": image_url }),
      headers: @extra_headers
    expect(response.status).to eq(200)
    @object.reload
    expect(json[attr.to_s]['original']).to eq("http://www.example.com#{@object.send(attr).url}")
  end

  it "#{attr}, allowing updates to #{attr} via file upload" do
    file = Rack::Test::UploadedFile.new(File.open('spec/support/files/glitch.png'))
    patch [@route, @object.send(@id_attr)].join('/'),
      params: @extra_params.merge({ "#{attr}": file }),
      headers: @extra_headers
    expect(response.status).to eq(200)
    @object.reload
    expect(json[attr.to_s]['original']).to eq("http://www.example.com#{@object.send(attr).url}")
  end

  it "#{attr}, throwing an exception for invalid image file" do
    file = Rack::Test::UploadedFile.new(__FILE__)
    patch [@route, @object.send(@id_attr)].join('/'),
      params: @extra_params.merge({ "#{attr}": file }),
      headers: @extra_headers
    expect(response).to_not be_ok
    expect(response.status).to eq(400)
    expect(json['errors'][attr.to_s].join).to match(/allowed types/)
  end

  it "#{attr}, allowing updating an existing image" do
    @object.update_attribute(attr, File.open('spec/support/files/glitch.png'))
    @object.reload
    old_url = @object.send(attr).url
    file = Rack::Test::UploadedFile.new(File.open('spec/support/files/liam.png'))
    patch [@route, @object.send(@id_attr)].join('/'),
      params: @extra_params.merge({ "#{attr}": file }),
      headers: @extra_headers
    expect(response.status).to eq(200)
    expect(json[attr.to_s]['original']).to_not eq("http://www.example.com#{old_url}")
    @object.reload
    expect(json[attr.to_s]['original']).to eq("http://www.example.com#{@object.send(attr).url}")
  end

  # If we pass a string into logo, CarrierWave will silently discard it.
  # We don't want that.
  it "#{attr}, validate #{attr} is a file" do
    patch [@route, @object.send(@id_attr)].join('/'),
      params: @extra_params.merge({ "#{attr}": 'I am clearly not an image' }),
      headers: @extra_headers
    expect(response).to_not be_ok
    expect(response.status).to eq(400)
  end
end
