shared_context 'a model with images for' do |klass_name, attrs, options|
  before :all do
    @model_name = klass_name
    @create_params = options&.dig(:create) || {}
  end

  (attrs.is_a?(Array) ? attrs : [attrs]).each do |attr|
    it "prefixes asset_host for #{attr} if set" do
      @model = FactoryGirl.create(klass_name, @create_params)
      @model.update_attribute(attr, File.open('spec/support/files/liam.png'))
      CarrierWave.configure { |config| config.asset_host = 'https://assets.example.com' }
      expect(@model.send(attr).url).to match(/^https:\/\/assets\.example\.com/)
      CarrierWave.configure { |config| config.asset_host = nil }
      # Resetting configure won't change an already-loaded class.
      # https://github.com/carrierwaveuploader/carrierwave/blob/540a84c606353a878d6574740e44f7970b754463/lib/carrierwave/uploader/configuration.rb#L138
      @model.send(attr).class.asset_host = nil
    end
  end
end
