shared_examples 'Sociable' do |options|
  before :all do
    @factory = options[:for]
  end

  describe '#social' do
    before :each do
      @object = FactoryGirl.create(@factory)
    end

    it 'must be a Hash' do
      @object.update(social: 'foo')
      expect(@object).to_not be_valid
      expect(@object.errors[:social]).to include('must be a hash (found String)')
    end

    it 'accepts all allowed keys' do
      social = Hash[Sociable::NETWORKS.map {|network| [network, "a #{network} url"]}]
      @object.update!(social: social)
      expect(@object).to be_valid
      @object.reload
      expect(@object.social).to eq(social)
    end

    it 'rejects unrecognized keys' do
      @object.update(social: {foo: 'bar'})
      expect(@object).to_not be_valid
      expect(@object.errors[:social]).to include('has unrecognized networks: "foo"')
    end
  end
end
