provider "aws" {
  region = "us-west-2"
  profile = "twitch-esports-aws"
}

provider "aws" {
  alias = "us-east-1"
  region = "us-east-1"
  profile = "twitch-esports-aws"
}

provider "aws" {
  alias = "dev"
  region = "us-west-2"
  profile = "twitch-esports-dev"
}

module "common" {
  source = "git::ssh://git@git-aws.internal.justin.tv/esports/terraform.git//modules/variables/twitch-esports-aws/"
}

variable "service_name" { default = "edb" }
variable "service_env" { default = "production" }
variable "zone" { default = "rlcs.gg" }

data "terraform_remote_state" "aws" {
  backend = "s3"
  config {
    bucket = "twitch-esports-aws"
    key = "tfstate/esports/terraform/aws/raw"
    profile = "twitch-esports-aws"
    region = "us-east-1"
  }
}

resource "aws_ecr_repository" "edb" {
  name = "edb"
}

resource "aws_route53_record" "production" {
  # zone_id = "Z39V61UJPEWKZR" # esports.army
  zone_id = "Z25565XZLSXXCE" # production.esports.engineering
  name = "edb"
  type = "A"

  alias {
    name = "${module.service.alb_dns_name}"
    zone_id = "${module.service.alb_zone_id}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "internal" {
  zone_id = "ZALZ14ARD67SH" # esports.internal.justin.tv
  provider = "aws.dev"
  name = "${var.service_name}.${var.service_env}"
  type = "A"

  alias {
    name = "${module.service.alb_dns_name}"
    zone_id = "${module.service.alb_zone_id}"
    evaluate_target_health = false
  }
}

output "ecr_url" {
  value = "${aws_ecr_repository.edb.repository_url}"
}
