data "aws_alb" "service" {
  name = "${var.service_name}"
}

module "alarms" {
  source = "git::ssh://git@git-aws.internal.justin.tv/esports/terraform.git//modules/alarms?ref=2017-05-19"

  namespace = "tourney/${var.service_name}/${var.service_env}"
  name_prefix = "${var.service_name}_${var.service_env}"
  service_name = "${var.service_name}"

  alb_4XX = false
  alb_5XX = false
  alb_arn_suffix = "${data.aws_alb.service.arn_suffix}"
  rails = true
  rails_exception_threshold = "8"

  insufficient_data_actions = ["${data.terraform_remote_state.dev.alarm_sns_topic_arn}"]
  alarm_actions = ["${data.terraform_remote_state.dev.alarm_sns_topic_arn}"]
  ok_actions = ["${data.terraform_remote_state.dev.alarm_sns_topic_arn}"]
}
