provider "aws" {
  region = "us-west-2"
  profile = "twitch-esports-dev"
}

provider "aws" {
  region = "us-east-1"
  profile = "twitch-esports-dev"
  alias = "us-east-1"
}

module "common" {
  source = "git::ssh://git@git-aws.internal.justin.tv/esports/terraform.git//modules/variables/twitch-esports-dev/"
}

variable "service_name" { default = "edb" }
variable "service_env" { default = "staging" }

data "terraform_remote_state" "dev" {
  backend = "s3"
  config {
    bucket = "twitch-esports-dev"
    key = "tfstate/esports/terraform/dev/raw"
    profile = "twitch-esports-dev"
    region = "us-east-1"
  }
}

resource "aws_ecr_repository" "edb" {
  name = "edb"
}

output "ecr_url" {
  value = "${aws_ecr_repository.edb.repository_url}"
}
