resource "aws_db_subnet_group" "default" {
  name = "${var.service_name}"
  subnet_ids = ["${split(",", lookup(data.terraform_remote_state.dev.ecs_cluster_tourney, "subnet_ids"))}"]
}

resource "aws_security_group" "db" {
  name = "${var.service_name}-db"
  description = "RDS for ${var.service_name}"
  vpc_id = "${lookup(data.terraform_remote_state.dev.ecs_cluster_tourney, "vpc_id")}"
  ingress {
    from_port = "5432"
    to_port = "5432"
    protocol = "tcp"
    cidr_blocks = ["10.0.0.0/8"]
  }
  egress {
    from_port = 0
    to_port = 0
    protocol = "-1"
    cidr_blocks = ["10.0.0.0/8"]
  }
}

resource "aws_db_instance" "default" {
  allocated_storage = 15
  engine = "postgres"
  engine_version = "9.5.4"
  instance_class = "db.t2.micro"
  name = "edb"
  username = "tourney"
  password = "tourn3yLUL"
  db_subnet_group_name = "${aws_db_subnet_group.default.name}"
  vpc_security_group_ids = ["${aws_security_group.db.id}"]
}
