data "aws_ecs_cluster" "tourney" {
  cluster_name = "tourney"
}

data "template_file" "smash_task_definition" {
  template = "${file("task-definitions/smash.json")}"
  vars {
    name = "edb"
    region = "us-west-2"
    image = "${replace(aws_ecr_repository.edb.repository_url, "https://", "")}:latest"
    db_url = "postgres://${aws_db_instance.default.username}:${aws_db_instance.default.password}@${aws_db_instance.default.endpoint}/${aws_db_instance.default.name}"
    cpu = 256
    mem = 512
  }
}

resource "aws_iam_role_policy" "smash_import" {
  name = "ecs_${var.service_name}_smash_import"
  role = "${aws_iam_role.task.id}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "ecs:RunTask"
            ],
            "Resource": [
                "${aws_ecs_task_definition.smash_import.arn}"
            ],
            "Condition": {
                "ArnLike": {
                    "ecs:cluster": "${data.aws_ecs_cluster.tourney.id}"
                }
            }
        }
    ]
}
EOF
}

resource "aws_ecs_task_definition" "smash_import" {
  family = "smash-import"
  container_definitions = "${data.template_file.smash_task_definition.rendered}"
  task_role_arn = "${aws_iam_role.task.arn}"
}

resource "aws_cloudwatch_event_target" "smash_import" {
  target_id = "smash-import"

  rule = "${aws_cloudwatch_event_rule.smash_import.name}"
  arn = "${data.aws_ecs_cluster.tourney.id}"
  role_arn = "${aws_iam_role.task.arn}"

  ecs_target = {
    task_count = 1
    task_definition_arn = "${aws_ecs_task_definition.smash_import.arn}"
  }
}

resource "aws_cloudwatch_event_rule" "smash_import" {
  name = "smash-import"
  description = "Import things from smash.gg"
  schedule_expression = "cron(0/1 * * * ? *)"
}
