
export interface ScoringRule {
  title: string;
  points: number;
  notes?: string;
}
export interface ResultBreakdown {
  amount: number;
  points: number;
}

export type ScoringKey = 'kills' | 'potg' | 'placement' | 'tweets';
export const SCORING_TYPES: ScoringKey[] = ['kills', 'potg', 'placement', 'tweets'];
export interface Results {
  total: number;
  breakdown: {
    [k in ScoringKey]: ResultBreakdown;
  };
}

export interface Contestant {
  name: string;
  scheduled: string;
  scheduledEnd: string;
  image: string;
  results: Results;
  next?: boolean;
}

export interface DataFile {
  scoring: ScoringRule[];
  contestants: Contestant[];
}
