import { Contestant } from 'common/constants';

export function pad(n: any, width: number, z?: any) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

function parseContestant(data: any): Contestant {
  const cont: Contestant = {
    name: data.StreamerName,
    scheduled: data.StreamStart,
    scheduledEnd: data.StreamEnd,
    image: `${data.StreamerName.toLowerCase()}.jpg`,
    results: undefined,
  };

  if (data.Total > 0) {
    cont.results = {
      total: data.Total,
      breakdown: {
        kills: {
          amount: data.Kills,
          points: data.KillsPoints,
        },
        potg: {
          amount: data.POTG,
          points: data.POTGPoints
        },
        placement: {
          amount: data.Placement,
          points: data.PlacementPoints
        },
        tweets: {
          amount: data.Tweets,
          points: data.TweetsPoints
        }
      }
    };
  }

  return cont;
}

export function loadContestantData(): Contestant[] {
  const data: any[] = require('data/streamer_data.json');
  return data.map(parseContestant);
}
