import { config } from 'config';

export function fetchWithHeaders(url: string) {
  return fetch(new Request(url, {
    headers: new Headers({
      Accept: 'application/vnd.twitchtv.v5+json',
      'Client-ID': config.twitch_client,
    })
  }))
  .then((response: any) => response.json());
}

export function getStreamStatus(streamId: string) {
  let url = `https://api.twitch.tv/kraken/streams/${streamId}`;
  return fetchWithHeaders(url);
}
