import * as React from 'react';
import * as moment from 'moment';
import { find } from 'lodash-es';

import { DataFile, Contestant } from 'common/constants';
import { loadContestantData, pad } from 'common/helpers';
import { getStreamStatus } from 'common/helpers/stream';
import { HeroSection } from 'ui/sections/hero';
import { LeaderboardSection } from 'ui/sections/leaderboard';
import { GiveawaySection } from 'ui/sections/giveaway';
import { FooterSection } from 'ui/sections/footer';
import { PlaySection } from 'ui/sections/play';
import { LiveStream } from 'ui/sections/stream';

require('common/styles/app.scss');

const data: DataFile = require('data/data.json');
const contestants: Contestant[] = loadContestantData();

export class App extends React.Component<any, any> {
  public constructor(props: any) {
    super(props);
    this.state = {
      live: undefined,
      next: undefined,
    };
  }

  public componentDidMount() {
    this.checkStatus();
  }

  public render() {
    const { live, next } = this.state;
    // const heroSection = <LiveStream contestant={live} />;
    const heroSection = live
      ? <LiveStream contestant={live} />
      : <HeroSection contestants={contestants} next={next}/>;

    return (
      <div className="page-container">
        {heroSection}
        <LeaderboardSection scoring={data.scoring} contestants={contestants} />
        <PlaySection />
        <GiveawaySection />
        <FooterSection />
      </div>
    );
  }

  private checkStatus () {
    // check if currently streaming
    const now = moment();
    // const now = moment('2017-12-15 09:01-08'); //to test it.
    let live = undefined;
    let currentNext = undefined;
    let timeUntil = Number.MAX_VALUE;
    for (const contestant of contestants) {
      if (now.isAfter(moment(contestant.scheduled))
          && now.isBefore(moment(contestant.scheduledEnd))) {
        live = contestant;
      }

      let until = moment.duration(moment(contestant.scheduled).diff(now)).asSeconds();
      if (until > 0 && until < timeUntil) {
        timeUntil = until;
        currentNext = contestant;
      }
    }

    this.setState({
      next: currentNext,
      live
    });
  }
}
