import * as React from 'react';
import * as Moment from 'moment';

import { ScoringKey, Contestant } from 'common/constants';
import { LeaderboardResults } from 'ui/components/leaderboard-results';
require('./styles.scss');

export interface LeaderboardEntryProps {
  rank: number;
  contestant: Contestant;
  maxByCategory: {[k in ScoringKey]: number};
}

export class LeaderboardEntry extends React.Component<any, any> {
  public render() {
    const { contestant, rank, maxByCategory } = this.props;
    const imageSrc = require(`common/assets/streamers/${contestant.image}`) as string;
    const imageStyle = { backgroundImage: `url(${imageSrc})` };
    const result = contestant.results
      ? <LeaderboardResults results={contestant.results} maxByCategory={maxByCategory} />
      : this.renderUpcoming();
    const currentRank = contestant.results
      ? rank
      : '-';
    return (
      <div className="leaderboard-entry__container">
        <div className="leaderboard-entry__player">
          <div className="leaderboard-entry__image" style={imageStyle}/>
          <div className="leaderboard-entry__rank">{currentRank}</div>
        </div>
        <div className="leaderboard-entry__name">
          {contestant.name}
        </div>
        {result}
      </div>
    );
  }

  private renderUpcoming() {
    const { contestant } = this.props;
    return (
      <div className="leaderboard-upcoming">
        <h3>Upcoming Stream</h3>
        <div className="leaderboard-upcoming__date">
          {Moment(contestant.scheduled).format('LLLL')}
        </div>
      </div>
    );
  }
}
