import * as React from 'react';
import { SCORING_TYPES, Results, ResultBreakdown, ScoringKey } from 'common/constants';
import { ProgressBar } from 'ui/components/progress-bar';
require('./styles.scss');

export interface LeaderboardResultsProps {
  results: Results;
  maxByCategory: {[k in ScoringKey]: number};
}

export class LeaderboardResults extends React.Component<LeaderboardResultsProps, any> {
  public render() {
    const { results } = this.props;
    const statResults = SCORING_TYPES.map((key: ScoringKey) => {
      return this.renderStatResult(key, results.breakdown[key]);
    });
    return (
      <div className="leaderboard-results">
        <div className="leaderboard-results__stats">
          {statResults}
        </div>
        <div className="leaderboard-results__total">
          {results.total}
        </div>
      </div>
    );
  }

  private renderStatResult(type: ScoringKey, scoring: ResultBreakdown) {
    const { maxByCategory } = this.props;
    const max = maxByCategory[type];
    return (
      <div className="leaderboard-stat">
        <div className="leaderboard-stat__title">{type}</div>
        <div className="leaderboard-stat__amount">{scoring.amount}</div>
        <ProgressBar bars={5} percent={scoring.points / max} />
        <div className="leaderboard-stat__points">+{scoring.points}</div>
      </div>
    );
  }
}
