import * as React from 'react';

import { ScoringRule } from 'common/constants';

require('./styles.scss');

export interface LeaderboardRulesProps {
  scoring: ScoringRule[];
}

export class LeaderboardRules extends React.Component<LeaderboardRulesProps, any> {
  public render() {
    const { scoring } = this.props;
    const ruleElements = scoring.map(this.renderRule);

    return (
      <div className="leaderboard-rules">
        <div className="leaderboard-rules__container">
          {ruleElements}
        </div>
        <div className="leaderboard-rules__fineprint">Leaderboards are updated once per day.</div>
      </div>
    );
  }

  private renderRule(rule: ScoringRule) {

    const notes = rule.notes
      ? <div className="leaderboard-rules__notes">*{rule.notes}</div>
      : undefined;
    return (
      <div className="leaderboard-rules__rule" key={rule.title}>
        <div className="leaderboard-rules__title">{rule.title}</div>
        <div className="leaderboard-rules__points">
          +{rule.points} <sup>points</sup>
        </div>
        {notes}
      </div>
    );
  }
}
