import * as React from 'react';
import { range } from 'lodash-es';
import { StreamerPreview } from 'ui/components/streamer-preview';

require('./styles.scss');

export interface ProgressBarProps {
  bars: number;
  percent: number;
}

export class ProgressBar extends React.Component<any, any> {
  public render() {
    const { bars, percent } = this.props;
    const filledStyles = {
      width: `${percent * 100}%`
    };
    // results of 0 glow otherwise
    const filledElement = percent > 0
      ? <div className="progress-bar__filled" style={filledStyles} />
      : undefined;

    return (
      <div className="progress-bar">
        <div className="progress-bar__container"/>
        {filledElement}
      </div>
    );
  }
}
