import * as React from 'react';
import * as Moment from 'moment';

require('./styles.scss');

export class StreamerPreview extends React.Component<any, any> {
  public render() {
    const { name, scheduled, next } = this.props;

    return (
      <div className="streamer-preview">
        {this.renderImage()}
        <div className="streamer-preview__name">{name}</div>
        <div className="streamer-preview__date">
          {Moment(scheduled).format('dddd, MM/DD')}<br/>
          {Moment(scheduled).format('h:mma')}
        </div>
      </div>
    );
  }

  private renderImage() {
    const { image, isNext } = this.props;
    const imageSrc = require(`common/assets/streamers/${image}`) as string;
    const imageStyle = { backgroundImage: `url(${imageSrc})` };
    const nextElement = isNext
      ? <div className="streamer-preview__next">Up Next</div>
      : undefined;
    return (
      <div className="streamer-preview__image-container">
        <div className="streamer-preview__image-mask">
          <div className="streamer-preview__image" style={imageStyle} />
          {nextElement}
        </div>
      </div>
    );
  }
}
