import * as React from 'react';
import { StreamerPreview } from 'ui/components/streamer-preview';

require('./styles.scss');

export class StreamerSchedule extends React.Component<any, any> {
  public render() {
    const { contestants } = this.props;
    const streamerPreview = contestants.map((data: any) => {
      return (
        <StreamerPreview
          key={data.name}
          isNext={this.props.next === data}
          {...data}
        />
      );
    });
    return (
      <section className="streamer-schedule">
        <div className="streamer-schedule__previews">
          {streamerPreview}
        </div>
        <div className="streamer-schedule__countdown">
          {this.props.countdown}
        </div>
      </section>
    );
  }
}
