import * as React from 'react';

require('./styles.scss');

export class FooterSection extends React.Component<any, any> {
  public render() {
    const twitchLogo = require('common/assets/logo_twitch.svg') as string;
    const blizzardLogo = require('common/assets/blizzard-logo.png') as string;
    const overwatchLogo = require('common/assets/ow-logo.png') as string;
    return (
      <section className="footer__container">
        <div className="footer__contents">
          <img className="footer__twitch-logo" src={twitchLogo} />
          <div className="footer__center-content">
            <img src={overwatchLogo} className="footer__overwatch" /><br/>
            Château Showdown
          </div>
          <img className="footer__blizzard-logo" src={blizzardLogo} />
          <div className="footer__copyright">
            &copy; 2017 BLIZZARD ENTERTAINMENT, INC. all rights reserved <br />
            <a className="footer__rules" href="/rules.pdf">Rules</a>
          </div>
        </div>
      </section>
    );
  }
}
