import * as React from 'react';
import * as moment from 'moment';

import { pad } from 'common/helpers';
import { StreamerSchedule } from 'ui/components/streamer-schedule';

require('./styles.scss');

export class HeroSection extends React.Component<any, any> {
  private interval: number;
  public constructor(props: any) {
    super(props);
    this.state = {
      countdown: undefined
    };
  }

  public componentDidMount() {
    if (this.props.next && !this.interval) {
      this.startCountdown();
    }
  }

  public componentDidUpdate(lastProps: any) {
    if (!lastProps.next && this.props.next && !this.interval) {
      this.startCountdown();
    }
  }

  public render() {
    const { contestants } = this.props;
    const logo = require('common/assets/ow-logo.png') as string;
    const logoStyle = { backgroundImage: `url(${logo})` };
    return (
      <section className="section-container section-container--hero">
        <div className="section-content hero-content">
          <div className="hero-content__logo" style={logoStyle} />
          <div className="hero-content__title">Château Showdown</div>
          <StreamerSchedule
            contestants={contestants}
            next={this.props.next}
            countdown={this.state.countdown}
          />
        </div>
      </section>
    );
  }

  private startCountdown() {
    this.setNewCountdown();
    this.interval = setInterval(() => {
      this.setNewCountdown();
    }, 1000);
  }

  private setNewCountdown() {
    if (!this.props.next) {
      return;
    }
    this.setState({
      countdown: this.buildCountdownString(this.props.next.scheduled)
    });
  }

  private buildCountdownString(time: moment.Moment) {
    const now = moment();
    // const now = moment('2017-12-15 09:01-08'); //to test it.
    const nextTime = moment(time);
    const duration = moment.duration(nextTime.diff(now));
    const hours = pad(Math.floor(duration.asHours()), 2);
    const minutes = pad(duration.minutes(), 2);
    const seconds = pad(duration.seconds(), 2);
    return `${hours}:${minutes}:${seconds}`;
  }
}
