import * as React from 'react';
import * as Moment from 'moment';
import { sortBy } from 'lodash-es';

import { Contestant, Results, ScoringRule, SCORING_TYPES } from 'common/constants';
import { LeaderboardRules } from 'ui/components/leaderboard-rules';
import { LeaderboardEntry } from 'ui/components/leaderboard-entry';

require('./styles.scss');

export interface LeaderboardSectionProps {
  scoring: ScoringRule[];
  contestants: Contestant[];
}

export class LeaderboardSection extends React.Component<LeaderboardSectionProps, any> {
  public render() {
    const { scoring, contestants } = this.props;
    // sort by score then date
    let sortedContestants = sortBy(contestants, (contestant) => {
      return Moment(contestant.scheduled);
    });
    sortedContestants = sortBy(sortedContestants, (contestant) => {
      const points = contestant.results
        ? contestant.results.total
        : 0;
      return -points;
    });
    // find max results for relative progress bars
    const maxByCategory = this.findMaxPerCategory();
    const streamerResults = sortedContestants.map((contestant: Contestant, idx: number) => {
      return (
        <LeaderboardEntry
          key={contestant.name}
          rank={idx + 1}
          contestant={contestant}
          maxByCategory={maxByCategory}
        />
      );
    });
    return (
      <section className="section-container section-container--leaderboard" >
        <div className="section-content leaderboard-content">
          <h1>LEADERBOARDS</h1>
          {streamerResults}
          <LeaderboardRules scoring={scoring}/>
        </div>
      </section>
    );
  }

  private findMaxPerCategory() {
    const { contestants } = this.props;
    const allValidResults = contestants
      .filter((contestant) => {
        return contestant.results;
      })
      .map((contestant) => contestant.results);
    return SCORING_TYPES.reduce((memo, type) => {
      const allScores = allValidResults.map((res) => res.breakdown[type].points);
      const max = Math.max(...allScores);
      return {
        ...memo,
        [type]: max
      };
    }, {});
  }
}
