const fs = require('fs-extra');

//var csv is the CSV file with headers
function csvJSON(csv){
    const lines = csv.split("\n");
    let result = [];
    const headers = lines[0].split(",");
    for(var i=1;i<lines.length;i++){
      const obj = {};
      const currentline = lines[i].split(",");
      for(var j=0; j<headers.length; j++){
        // cleanup carriage returns
        const header = headers[j].replace('\r', '');
        const content = currentline[j].replace('\r', '');
        obj[header] = content;
      }
      result.push(obj);
    }
    
    //return result; //JavaScript object
    return result;
  }

const file = './data.csv';
const outputLoc = './app/data/streamer_data.json';
fs.readFile(file, 'utf8')
  .then((data) => {
    const results = csvJSON(data);
    return fs.writeFile(outputLoc, JSON.stringify(results, null, 2));
  })
  .then((writeResult) => {
    console.log('successfully wrote ', outputLoc);
  });
