provider "aws" {
    region = "us-west-2"
    profile = "twitch-esports-aws"
}

resource "aws_s3_bucket" "web" {
  bucket = "www.chateaushowdown.com"
  acl    = "public-read"
  policy = "${file("policy.json")}"

  website {
    index_document = "index.html"
    error_document = "error.html"
  }
}

resource "aws_route53_record" "www" {
  zone_id = "Z2YOKWKVWD4NCF"
  name    = "www.chateaushowdown.com"
  type    = "A"
  alias {
    name    = "${aws_s3_bucket.web.website_domain}"
    zone_id = "${aws_s3_bucket.web.hosted_zone_id}"
    evaluate_target_health = false
  }
}
