'use strict';

const path = require('path');
const process = require('process');
const { BundleAnalyzerPlugin } = require('webpack-bundle-analyzer');
const webpack = require('webpack');
const RollbarSourceMapPlugin = require('rollbar-sourcemap-webpack-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
let basePath = __dirname;
const baseUrl = '';

module.exports = {
  name: 'fig',
  entry: './app/ui/index.tsx',
  target: 'web', // default
  devServer: {
    inline: true,
    hot: true,
    port: 5200,
    disableHostCheck: true
  },
  plugins: [
    // new RollbarSourceMapPlugin({
    //   accessToken: process.env.ROLLBAR_SERVER_ACCESS_TOKEN,
    //   version: process.env.VERSION,
    //   publicPath: baseUrl
    // }),
    // new BundleAnalyzerPlugin(),
    new HtmlWebpackPlugin({
      title: '',
      template: 'index.ejs',
      favicon: 'favicon.ico'
    }),
    new webpack.HotModuleReplacementPlugin(),
    new webpack.EnvironmentPlugin({
      NODE_ENV: 'development',
      // VERSION: undefined,
      // ROLLBAR_ACCESS_TOKEN: undefined,
    })
  ],
  output: {
    path: path.join(process.cwd(), '/dist/'),
    publicPath: '/',
    filename: 'bundle-[hash].js'
  },
  resolve: {
    alias: {
      config: path.join(__dirname, 'config', process.env.NODE_ENV || 'development')
    },
    extensions: ['.js', '.jsx', '.ts', '.tsx'],
    modules: [
      path.join(__dirname, 'app'),
      path.join(__dirname, 'node_modules')    ]
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        loader: 'ts-loader',
        exclude: [/node_modules/, /dist/, /vendor/],
        query: {
          // Most of these are related to having multiple TS definitions
          // deep within node_modules when symlinking libs/etc.
          ignoreDiagnostics: [
            2403,
            2324, // Property missing in compound type.. wasn't there a TS issue about this?
            2687, // All declarations of ... must have identifcal
            2300, // Duplicate identifier..
            2339, // connected components IntrinsicAttributes
            7016  // No definitions for react-moment :(
          ]
        }
      },
      {
        enforce: 'pre',
        test: /\.js$/,
        loader: "source-map-loader"
      },
      {
        enforce: 'pre',
        test: /\.tsx?$/,
        use: "source-map-loader"
      },
      {
        test: /\.scss$/,
        use: [
          'style-loader',
          'css-loader',
          {
            loader: 'sass-loader',
            options: {
              includePaths: [path.resolve(__dirname, "./app/common/styles")]
            }
          }
        ]
      },
      {
        test: /\.(gif|jpg|png|svg|woff|woff2|eot|ttf|svg)$/,
        loader: 'file-loader'
      }
    ]
  },
   devtool: process.env.NODE_ENV === 'development' ? 'inline-source-map' : 'source-map',
};
