import React from 'react';
import Clips from './Clips';

require('./App.scss');

export default class App extends React.Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    window.addEventListener("scroll", this.handleScroll);
  }

  handleScroll() {
    window.requestAnimationFrame(() => {
      const scrollTop = window.pageYOffset || documentElement.scrollTop || body.scrollTop || 0;
      const newTop = (scrollTop * 0.6) <= 0 ? 0 : (scrollTop * 0.6);
      this.hero.style.top = newTop;
      /* this.hero.childNodes[0].style.top = newTop * 0.075; */
    });
  }

  render() {
    const logo = require('../images/logo.png'),
          blizzardLogo = require('../images/blizzard-logo.svg'),
          twitchLogo = require('../images/twitch-logo.svg'),
          bulletImage = require('../images/bulletpoint.png');

    return <div>
      <div id="hero" ref={c => this.hero = c}><div /></div>
      <div id="content">
        <div className="pr">
          <img src={logo} className="necro" />
          <p>Want a chance to win some scary good Diablo loot? Clip and share epic Necromancer moments from your favorite Diablo streamers. The top 3 most popular clips will be featured on social media, and both the streamer &amp; clip creator will win some great Diablo loot!</p>
          <hr />
          <p><b>Make sure your clip follows these rules:</b></p>
          <ul>
            <li><img src={bulletImage} /> Creative title describing the clip along with the hashtag <b>#NecroContestEntry</b></li>
            <li><img src={bulletImage} /> Clip must not exceed 60 seconds</li>
          </ul>
          <p>You can read the full <a href="https://help.twitch.tv/customer/portal/articles/2830601-twitch-necromancer-clips-contest-official-rules">official rules here</a>. Good luck Nephalem!</p>
        </div>
        <Clips/>
      </div>
      <footer>
        <img src={blizzardLogo} />
        <img src={twitchLogo} />
        <br />
        <a href="https://help.twitch.tv/customer/portal/articles/2830601-twitch-necromancer-clips-contest-official-rules">Rules</a>
        <a href="https://diablo3.com">Play Diablo 3</a>
      </footer>
    </div>;
  }
}
