import React from 'react';
import deepEqual from 'deep-equal';
/* import fetch from 'whatwg-fetch'; */
//
//
// https://api.twitch.tv/kraken/clips/top?game=Diablo%20III%3A%20Reaper%20of%20Souls&limit=20&period=day&on_site=1
// period=all
// trending=true

require('./Clips.scss');

export default class App extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      clips: [],
      sort: 'trending'
    };
  }

  shouldComponentUpdate(nextProps, nextState) {
    if(nextState.sort === this.state.sort &&
        deepEqual(nextState.clips, this.state.clips)) {
      return false;
    }
    return true;
  }

  componentDidUpdate() {
    this.loadClips();
  }

  componentDidMount() {
    this.loadClips();
  }

  loadClips() {
    let clipsUrl = 'https://api.twitch.tv/kraken/clips/top?game=Diablo%20III%3A%20Reaper%20of%20Souls&limit=20&client_id=pxmnd6hn13qpb3gksvybduqwxnsa7x';

    switch(this.state.sort) {
      case 'trending':
        clipsUrl = clipsUrl.concat('&period=all&trending=true');
        break;
      case 'top':
        clipsUrl = clipsUrl.concat('&period=all');
        break;
      case 'top24h':
        clipsUrl = clipsUrl.concat('&period=day');
        break;
      case 'top7d':
        clipsUrl = clipsUrl.concat('&period=week');
        break;
      case 'top30d':
        clipsUrl = clipsUrl.concat('&period=month');
        break;
    }

    this.clips = fetch(clipsUrl, { headers: { accept: 'application/vnd.twitchtv.v5+json' } }).
      then(response => response.json()).
      then((data) => {
        this.setState({
          clips: data.clips
        });
      }).
      catch(e => console.log(e));
  }

  setSort(sort) {
    return (e) => {
      e.preventDefault();
      this.setState({sort});
      return false;
    };
  }

  /* {this.state.clips.map((clip, idx) => <div dangerouslySetInnerHTML={{__html: clip.embed_html}}/>)} */
  render() {
    const clips = this.state.clips.map((clip, idx) => {
      return <li>
        <a href={clip.url} className="thumb">
          <img src={clip.thumbnails.medium} />
          <span className="views">{clip.views} &#128065;</span>
          <span className="broadcaster"><img src={clip.broadcaster.logo}/> {clip.broadcaster.display_name}</span>
          <span className="duration">{Math.floor(clip.duration)}s</span>
        </a>
        <a href={clip.url}><span className="title">{clip.title}</span></a>
        <span className="curator">Clipped by <a href={clip.curator.channel_url}>{clip.curator.display_name}</a></span>
      </li>;
    });

    return <div id="clips">
      <div className="content">
        <div className="sort">
          <span>Sort:</span>
          <ul>
            <li onClick={this.setSort('trending')} className={this.state.sort == 'trending' ? 'active' : ''}><a href="">Trending</a></li>
            <li onClick={this.setSort('top')} className={this.state.sort == 'top' ? 'active' : ''}><a href="">Top <span className="period">all</span></a></li>
            <li onClick={this.setSort('top24h')} className={this.state.sort == 'top24h' ? 'active' : ''}><a href="">Top <span className="period">day</span></a></li>
            <li onClick={this.setSort('top7d')} className={this.state.sort == 'top7d' ? 'active' : ''}><a href="">Top <span className="period">week</span></a></li>
            <li onClick={this.setSort('top30d')} className={this.state.sort == 'top30d' ? 'active' : ''}><a href="">Top <span className="period">month</span></a></li>
          </ul>
          <a href="https://www.twitch.tv/directory/game/Diablo%20III:%20Reaper%20of%20Souls/clips" className="button">Clip on Twitch</a>
        </div>
        <hr className="dark" />
        <ul className="clips">{clips}</ul>
      </div>
    </div>;
  }
}
