# notify-slack

It ..notifies slack! Install the gem, or use the docker image.

Configuration options can either be passed via command line arguments, environment variables, or a `slack.yml` configuration file (which will not be read when running the docker image currently.)

 - `-w` `--webhook` `SLACK_WEBHOOK`
 - `-c` `--channel` `SLACK_CHANNEL`
 - `-u` `--username` `SLACK_USERNAME`
 - `-b` `--build-status` `BUILD_STATUS` ("success" or "failure")
 
Build status sets username and emoji to Jenkins and builds the build status message for you. 

For example usage in a post build task, [see the esports-edb project](https://jenkins.internal.justin.tv/view/esports/job/esports-edb/configure)

```
#!/bin/bash
export SLACK_WEBHOOK=
export SLACK_CHANNEL=
docker pull docker.internal.justin.tv/esports/notify-slack:latest && \
docker run \
	-v `pwd`:/build \
   	--env-file <(env | grep "\(SLACK_\|BUILD_\|JOB_\|GIT_\)") \
    docker.internal.justin.tv/esports/notify-slack:latest
```

Builds of this are published to the internal docker registry at `docker.internal.justin.tv/esports/notify-slack:latest`
