import { getArticles } from 'tourney-sdk-react';
import { config } from 'config';
require('isomorphic-fetch');

import { Action } from './action-type';
import { ArticleModel } from 'tourney-sdk-react';

export const SET_ARTICLES = 'SET_ARTICLES';
export interface SetArticlesAction extends Action<typeof SET_ARTICLES, string[]> {}

export function createSetArticlesAction(articleIds: string[]): SetArticlesAction {
  return {
    type: SET_ARTICLES,
    payload: articleIds
  };
}

export function fetchArticles() {
  return async (dispatch: any) => {
    let articles = await dispatch(getArticles({
      parent_type: 'Game',
      parent_id: config.cmsGameId,
      limit: 150
    }));
    const ids = articles.map((t: ArticleModel) => t.id);
    dispatch(createSetArticlesAction(ids));
    return ids;
   };
}

export type ArticleActions = SetArticlesAction;
