import { config } from 'config';
import {
  getSeries,
  getSchedule,
  SeriesModel
} from 'tourney-sdk-react';
require('isomorphic-fetch');

import { Action } from './action-type';
import { ScheduleModel } from 'state/schedule/model';

export const SET_SCHEDULE = 'SET_SCHEDULE';
export interface SetScheduleAction extends Action<typeof SET_SCHEDULE, ScheduleModel> {}

// this will be an array of series ids in order?
export function createSetScheduleAction(scheduleSettings: ScheduleModel): SetScheduleAction {
  return {
    type: SET_SCHEDULE,
    payload: scheduleSettings
  };
}

export function fetchSchedule(from: string, to: string, seasonId: string) {
  return async (dispatch: any) => {
    let results = await dispatch(getSchedule({ from, to, season_id: seasonId, limit: 500 }));
    // let results = await dispatch(getSchedule({ from, to, limit: 500 }));
    const items = results.map((item: any) => {
      let type = item.type;
      if (type.indexOf('::') !== -1) {
        type = type.split('::')[0];
      }
      return {
        id: item.id,
        schema: type.toLowerCase()
      };
    });
    dispatch(createSetScheduleAction({ from, to, items }));
    return items;
  };
}

export type ScheduleActions = SetScheduleAction;
