import { values } from 'lodash';
import { SiteAttribute } from 'ui/components/footer';
import { Section } from 'ui/components/navigation';
import { Sponsor } from 'ui/components/sponsor-bar';

export interface SocialLink {
  label: string;
  url: string;
  icon: string;
  baseUrl?: string;
}

export const TEAM_SECTIONS = [
  'about',
  'roster',
  'matches',
];

export const TOURNAMENT_NAMES: any = {
  'RLCS S4 World Championship': {
    name: 'Rocket League World Championship',
    region: undefined,
  },
  'NA RLCS': {
    name: 'Rocket League Championship Series',
    region: 'North America',
  },
  'EU RLCS': {
    name: 'Rocket League Championship Series',
    region: 'Europe',
  },
  'NA RLRS': {
    name: 'Rocket League Rival Series',
    region: 'North America',
  },
  'EU RLRS': {
    name: 'Rocket League Rival Series',
    region: 'Europe',
  },
  'EU RLCS/RLRS Promotion': {
    name: 'RLCS Promotion',
    region: 'Europe',
  },
  'NA RLCS/RLRS Promotion': {
    name: 'RLCS Promotion',
    region: 'North America',
  }
};

export const TOURNAMENT_COLORS: {[key: string]: string} = {
  'NA RLCS': '#d22337',
  'EU RLCS': '#4077B6',
  'NA RLRS': '#3a3a3a',
  'EU RLRS': '#3a3a3a',
};

export const TOURNAMENT_CLASSES: {[key: string]: string} = {
  'NA RLCS': 'na-rlcs',
  'EU RLCS': 'eu-rlcs',
  'NA RLRS': 'na-rlrs',
  'EU RLRS': 'eu-rlrs',
};

export const TOURNAMENT_WHITELIST: {[key: string]: string} = {
  'NA RLCS': 'na-rlcs',
  'EU RLCS': 'eu-rlcs',
  'NA RLRS': 'na-rlrs',
  'EU RLRS': 'eu-rlrs',
};

export const TICKER_THRESHOLD = 500;

export const TEAM_SOCIALS: SocialLink[] = [{
  label: 'facebook',
  url: undefined,
  icon: 'fa fa-facebook',
  baseUrl: 'https://www.facebook.com/'
}, {
  label: 'twitter',
  url: undefined,
  icon: 'fa fa-twitter',
  baseUrl: 'https://twitter.com/'
}, {
  label: 'twitch',
  url: undefined,
  icon: 'fa fa-twitch',
  baseUrl: 'https://www.twitch.tv/'
}, {
  label: 'youtube',
  url: undefined,
  icon: 'fa fa-youtube',
  baseUrl: 'https://www.youtube.com/'
}];

export const TOURNAMENTS = {
  RLCS: {
    abbr: 'RLCS',
    title: 'Rocket League Championship Series',
    id: 123,
    logo: require('common/assets/logo_s4.svg') as string,
  },
  RLRS: {
    abbr: 'RLRS',
    title: 'Rocket League Rival Series',
    id: 456,
    logo: require('common/assets/logo-rlrs.png') as string,
  }
};
export const ALL_TOURNAMENTS = values(TOURNAMENTS);

export const SEASON_NAME = 'Season 4';
export const SCHEDULE_INTERVAL = 3 * 60; // in seconds

export const CHANNEL = 'rocketleague';
export const CHANNEL_ID = 57781936;

// export const CHANNEL = 'riotgames';
// export const CHANNEL_ID = 36029255;
export const GAME = 'Rocket League';

const lorumIpsum = `Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce aliquet est sit amet cursus sollicitudin. Mauris eleifend, tortor sit amet porttitor ornare, purus tellus suscipit lectus, ut hendrerit libero est non odio. Nullam ex dui, molestie quis lectus ac, suscipit interdum dolor. Nam nec efficitur orci. Curabitur fermentum vulputate eros. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Proin interdum velit ac neque vehicula tincidunt. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque nec venenatis nisi. Nulla elementum nibh nulla. Pellentesque ac justo mi.<br/><br/>Curabitur eu risus molestie, dictum augue in, lobortis erat. Nam sollicitudin risus consequat tellus blandit, vitae aliquet tellus consectetur. Phasellus in ullamcorper leo. Cras convallis rutrum arcu. Vivamus condimentum vehicula pharetra. Aenean ac commodo lacus, id condimentum quam. Aliquam ut orci sit amet nibh elementum convallis ut a nisl. Aliquam eu lobortis arcu, vel egestas ex. Ut sed luctus erat, et luctus mi. Sed aliquet fermentum nulla, a imperdiet quam dignissim sit amet. Nullam auctor tristique velit quis viverra.<br/><br/>Sed sollicitudin orci libero, quis porta turpis semper sit amet. Pellentesque elementum magna et urna bibendum, a vehicula elit facilisis. Duis et facilisis risus. Sed vitae sapien venenatis, laoreet elit vitae, maximus lacus. Nunc neque nunc, pulvinar ac imperdiet sit amet, efficitur non tellus. Aenean placerat consectetur arcu, et viverra nisl pretium non. In efficitur, felis ut mattis fermentum, dolor risus blandit enim, eget tincidunt mauris risus ut elit. Pellentesque dapibus metus magna, a posuere neque vestibulum elementum. In hac habitasse platea dictumst. Phasellus laoreet mollis nibh, sit amet efficitur tellus venenatis ac. Quisque finibus dictum consectetur. Donec tempus augue eu dolor aliquam hendrerit. Nam nulla odio, euismod in tincidunt ut, varius id erat. Nam tempus enim vitae risus sollicitudin viverra.<br/><br/>Ut ante nulla, convallis vitae odio non, tempor iaculis magna. Donec a auctor nulla. Morbi aliquet lacinia erat, quis ultrices urna. Vivamus tempor scelerisque luctus. Sed consectetur leo a eleifend pharetra. Vestibulum non erat finibus, tristique nisi ac, luctus nulla. Cras in fringilla lorem. Donec gravida mi in faucibus eleifend. Maecenas tempus ornare luctus. Nunc ullamcorper, arcu eget commodo faucibus, quam neque congue arcu, ut elementum justo quam et nulla.<br/><br/>Maecenas elit ligula, cursus quis erat ut, ultricies placerat ex. Sed at fringilla nibh, quis congue leo. Etiam malesuada condimentum ipsum, vel feugiat velit maximus quis. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Quisque eget viverra massa. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Quisque tempus cursus scelerisque. Mauris vehicula, urna a molestie bibendum, nisi massa efficitur est, eu convallis ex quam quis tellus. Nunc non mattis felis, eu laoreet lectus. Curabitur suscipit dictum ex eu convallis. Cras bibendum sem lorem, a hendrerit enim iaculis sed. Maecenas justo orci, cursus eget ullamcorper at, bibendum ac est. Phasellus vel maximus mi. Nunc eu quam tristique, placerat nisl vel, aliquam tellus. Cras varius congue nunc sit amet efficitur.`;

export const SECTIONS: Section[] = [{
  title: 'NEWS',
  url: '/news',
  activeUrls: [/^\/news/, /^\/$/, /^$/]
}, {
  title: 'SCHEDULE',
  url: '/schedule'
}, {
  title: 'TEAMS',
  url: '/teams',
  activeUrls: [/^\/teams/]
}, {
  title: 'RESULTS',
  url: '/results',
  activeUrls: [/^\/results/]
}];

export const SOCIALS: SocialLink[] = [{
  label: 'FACEBOOK',
  url: 'https://facebook.com/RLCS/',
  icon: 'fa fa-facebook'
}, {
  label: 'TWITTER',
  url: 'https://twitter.com/rlcs',
  icon: 'fa fa-twitter'
}, {
  label: 'REDDIT',
  url: 'https://www.reddit.com/r/RocketLeague/',
  icon: 'fa fa-reddit'
}, {
  label: 'TWITCH',
  url: 'https://www.twitch.tv/rocketleague',
  icon: 'fa fa-twitch'
}, {
  label: 'YOUTUBE',
  url: 'https://www.youtube.com/channel/UCdKuPY64fEpI4cdlBSyvEJw',
  icon: 'fa fa-youtube-play'
}];

export const SITE_ATTRIBUTES: SiteAttribute[] = [{
  src: require('common/assets/logo_twitch.svg') as string
}, {
  src: require('common/assets/logo_psyonix.svg') as string
}];

export const SPONSORS: Sponsor[] = [{
  title: 'nissin',
  src: require('common/assets/sponsors_nissin.svg') as string
}, {
  title: 'brisk',
  src: require('common/assets/sponsors_brisk.svg') as string
}, {
  title: 'old-spice',
  src: require('common/assets/sponsors_oldspice.svg') as string
}, {
  title: 'mobile1',
  src: require('common/assets/sponsors_mobile1.svg') as string
}, {
  title: 'hyperx',
  src: require('common/assets/sponsors_hyperx.svg') as string
}, {
  title: 'mgm',
  src: require('common/assets/sponsors_mgm2.svg') as string
}];

export const DESKTOP_NAVIGATION_HEIGHT = 100;
export const MOBILE_NAVIGATION_HEIGHT = 60;
export const TEAM_NAV_HEIGHT = 70;
export const MOBILE_BREAK = 768;

export const REGISTER_URL = 'https://www.smash.gg/rlcs4';

export const STAGE_TYPES = {
  ROUND_ROBIN: 'TournamentStage::RoundRobin',
  SINGLE_ELIMINATION: 'TournamentStage::SingleElim',
  DOUBLE_ELIMINATION: 'TournamentStage::DoubleElim',
};

export interface BracketSeries {
  ident: string | undefined;
  connection: 'straight' | 'bend-up' | 'bend-down' | undefined;
}

export interface BracketRound {
  title: string;
  size: number;
  series: BracketSeries[];
}

export interface BracketType {
  name: string;
  height: number;
  rounds: BracketRound[];
}

export const SINGLE_ELIM_FORMAT: BracketType[] = [{
  name: 'Bracket',
  height: 2,
  rounds: [{
    title: 'Quarter-Final',
    size: 2,
    series: [{
      ident: 'A',
      connection: 'straight',
      }, {
      ident: 'B',
      connection: 'straight'
    }]
  }, {
    title: 'Semi-Final',
    size: 2,
    series: [{
      ident: 'C',
      connection: 'bend-down',
      }, {
      ident: 'D',
      connection: 'bend-up'
    }]
  }, {
    title: 'Final',
    size: 1,
    series: [{
      ident: 'E',
      connection: undefined
    }]
  }]
},
{
  name: 'Tiebreaker',
  height: 1,
  rounds: [{
    title: '3rd Place',
    size: 1,
    series: [{
      ident: 'F',
      connection: undefined
    }]
  }]
}];

export const DOUBLE_ELIM_FORMAT: BracketType[] = [{
  name: 'Winners Bracket',
  height: 2,
  rounds: [{
    title: 'Semi-Final',
    size: 2,
    series: [{
      ident: 'A',
      connection: 'bend-down',
      }, {
      ident: 'B',
      connection: 'bend-up'
    }]
  }, {
    title: 'Winner Qualifies',
    size: 1,
    series: [{
      ident: 'C',
      connection: undefined,
      }]
  }]
},
{
  name: 'Losers Bracket',
  height: 1,
  rounds: [{
    title: 'Lower Semi-Final',
    size: 1,
    series: [{
      ident: 'F',
      connection: 'straight',
    }]
  }, {
    title: 'Winner Qualifies',
    size: 1,
    series: [{
      ident: 'G',
      connection: undefined,
    }]
  }]
}];

export const FINALS_FORMAT: BracketType[] = [{
  name: 'Winners Bracket',
  height: 4,
  rounds: [{
    title: 'Upper Round 1',
    size: 4,
    series: [{
      ident: 'A',
      connection: 'straight',
    }, {
      ident: undefined,
      connection: undefined,
    }, {
      ident: 'B',
      connection: 'straight'
    }, {
      ident: undefined,
      connection: undefined,
    }]
  }, {
    title: 'Upper Quarter-Final',
    size: 4,
    series: [{
      ident: 'C',
      connection: 'bend-down',
    }, {
      ident: 'D',
      connection: 'bend-up',
    }, {
      ident: 'E',
      connection: 'bend-down'
    }, {
      ident: 'F',
      connection: 'bend-up',
    }]
  }, {
    title: 'Upper Semi-Final',
    size: 2,
    series: [{
      ident: 'G',
      connection: 'bend-down',
    }, {
      ident: 'H',
      connection: 'bend-up',
    }]
  }, {
    title: 'Upper Final',
    size: 1,
    series: [{
      ident: 'I',
      connection: 'straight',
    }]
  }, {
    title: 'Grand Final',
    size: 1,
    series: [{
      ident: 'J',
      connection: 'straight',
    }]
  }]
},
{
  name: 'Losers Bracket',
  height: 2,
  rounds: [{
    title: 'Lower Round 1',
    size: 2,
    series: [{
      ident: 'L',
      connection: 'straight',
    }, {
      ident: 'M',
      connection: 'straight',
    }]
  }, {
    title: 'Lower Round 2',
    size: 2,
    series: [{
      ident: 'N',
      connection: 'straight',
    }, {
      ident: 'O',
      connection: 'straight',
    }]
  }, {
    title: 'Lower Quarter-Final',
    size: 2,
    series: [{
      ident: 'P',
      connection: 'bend-down',
    }, {
      ident: 'Q',
      connection: 'bend-up',
    }]
  }, {
    title: 'Lower Semi-Final',
    size: 1,
    series: [{
      ident: 'R',
      connection: 'straight',
    }]
  }, {
    title: 'Lower Final',
    size: 1,
    series: [{
      ident: 'S',
      connection: undefined,
    }]
  }]
}];
